import React from "react";
import { useNavigate } from "react-router-dom";

export default function AdminCars() {
  // Example static data (you can later fetch this from backend)
  const cars = [
    { id: 1, name: "Tesla Model 3", status: "Available", price: "$45,000" },
    { id: 2, name: "BMW M3", status: "Rented", price: "$62,000" },
    { id: 3, name: "Audi A4", status: "Available", price: "$41,000" },
  ];
  const navigate = useNavigate();   

  return (
    <div>
       <div className="flex justify-between items-center mb-6">
        <h2 className="text-2xl font-semibold">Cars Management</h2>

        {/* ✅ Add New Car Button */}
        <button
          onClick={() => navigate("add")}
          className="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition"
        >
          + Add New Car
        </button>
      </div>

      <div className="overflow-x-auto bg-white shadow rounded-lg">
        <table className="min-w-full text-left border-collapse">
          <thead className="bg-gray-100 border-b">
            <tr>
              <th className="py-3 px-4 font-semibold text-gray-600">ID</th>
              <th className="py-3 px-4 font-semibold text-gray-600">Name</th>
              <th className="py-3 px-4 font-semibold text-gray-600">Status</th>
              <th className="py-3 px-4 font-semibold text-gray-600">Price</th>
              <th className="py-3 px-4 font-semibold text-gray-600">Actions</th>
            </tr>
          </thead>
          <tbody>
            {cars.map((car) => (
              <tr
                key={car.id}
                className="border-b hover:bg-gray-50 transition-colors"
              >
                <td className="py-3 px-4">{car.id}</td>
                <td className="py-3 px-4">{car.name}</td>
                <td className="py-3 px-4">{car.status}</td>
                <td className="py-3 px-4">{car.price}</td>
                <td className="py-3 px-4">
                  <button className="text-blue-600 hover:underline mr-3">
                    Edit
                  </button>
                  <button className="text-red-600 hover:underline">
                    Delete
                  </button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
