// src/pages/CarDetails.jsx
import { useParams } from "react-router-dom";
import cars from "../Data"; // your static data
import { Link } from "react-router-dom";

export default function CarDetails() {
  const { id } = useParams();
  const car = cars.find(c => c.id === parseInt(id));

  if (!car) return <div className="p-6 text-center">Car not found</div>;

  return (
    <div className=" px-12 py-10">
        <div className="flex flex-col md:flex-row gap-5 ">
            <div className="shadow-md md:w-1/2 rounded-2xl">
            <div>
      <img
        src={car.image}
        alt={car.name}
        className="w-full  object-cover rounded-t-2xl "
      />
      <div className="flex  mt-2 px-2 justify-between">
        <div className="p-1 border border-stone-300">
        <img src="https://place-hold.it/150x100" alt="" />
        </div>
        <div className="p-1 border border-stone-300">
        <img src="https://place-hold.it/150x100" alt="" />
        </div>
         <div className="p-1 border border-stone-300">
        <img src="https://place-hold.it/150x100" alt="" />
        </div>
         <div className="p-1 border border-stone-300">
        <img src="https://place-hold.it/150x100" alt="" />
        </div>
      </div>
      </div>
      <div className="p-4">
       <h1 className="text-3xl font-bold mt-3 mb-2">{car.name} {car.model}</h1>
     
      </div>
      <div>

      </div>
      </div>
      <div className="md:w-1/2 p-4 shadow-md rounded-2xl   ">
      <h1 className="text-3xl font-[500]">${car.price}/day</h1>
      <div className="mt-3 border-t border-stone-300 pt-2">
        <h3 className="text-gray-300">Subsrcipton Plan</h3>
        <div className="px-3">
        <div className="mt-2 border-1 border-gray-300 rounded-xl">
            <div className="flex justify-between bg-blue-950  p-2  text-white rounded-t-xl">
                <h1 className="font-bold text-lg">48 Months</h1>
                <p>$50</p>
                 </div>
                  <div className="flex justify-between  p-2 text-blue-900 font-bold border-b border-gray-300">
                <h1 className=" text-lg">36 Months</h1>
                <p>$50</p>
                 </div>
                 <div className="flex justify-between  p-2 text-blue-900 font-bold border-b border-gray-300">
                <h1 className=" text-lg">24 Months</h1>
                <p>$50</p>
                 </div>
                 <div className="flex justify-between  p-2 text-blue-900 font-bold border-b border-gray-300">
                <h1 className=" text-lg">12 Months</h1>
                <p>$50</p>
                 </div>
                   <div className="flex justify-between  p-2 text-blue-900 font-bold ">
                <h1 className=" text-lg">6 Months</h1>
                <p>$50</p>
                 </div>
            
        </div>
        </div>
        <div className="mt-4 px-3">
        <button className="w-full bg-blue-950 text-white py-2 ">Book Now</button>
        </div>
      </div>
        
      </div>
      </div>
     
      

        <div className="max-w-7xl px-10 py-2 mx-auto  mt-10 shadow-lg">
      <div className=" md:grid grid-cols-6 gap-4 mb-6 mt-10 text-lg 
         font-[500]">
        <div className="bg-stone-100  p-4 rounded-2xl mb-2 ">
           <i className='bx bxs-car text-3xl text-blue-500'></i>
            <h1>Gear Box</h1>
            <p>yes</p>
        </div>
        
          <div className="bg-stone-100  p-4 rounded-2xl mb-2">
            <i class='bx bx-bluetooth text-3xl text-blue-500' ></i>
            <h1>Gear Box</h1>
            <p>yes</p>
        </div>
          <div className="bg-stone-100  p-4 rounded-2xl mb-2">
           <i class='bx bx-bluetooth text-3xl text-blue-500' ></i>
            <h1>Gear Box</h1>
            <p>yes</p>
        </div>
         <div className="bg-stone-100  p-4 rounded-2xl mb-2">
            <i class='bx bx-bluetooth text-3xl text-blue-500' ></i>
            <h1>Gear Box</h1>
            <p>yes</p>
        </div>
          <div className="bg-stone-100  p-4 rounded-2xl mb-2">
            <i class='bx bx-bluetooth text-3xl text-blue-500' ></i>
            <h1>Gear Box</h1>
            <p>yes</p>
        </div>
          <div className="bg-stone-100  p-4 rounded-2xl mb-2">
            <i class='bx bx-bluetooth text-3xl text-blue-500' ></i> 
            <h1>Gear Box</h1>
            <p>yes</p>
        </div>
      </div>
      </div>

      <Link
        to="/cars"
        className="inline-block bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 mt-4"
      >
        ← Back to Cars
      </Link>
    </div>
  );
}
