<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Car;

class CarController extends Controller
{
    /**
     * Store a newly created car in the database.
     */
    public function store(Request $request)
    {
        // Validate incoming request
        $request->validate([
            'name' => 'required|string|max:255',
            'model' => 'required|string|max:10',
            'color' => 'required|string|max:50',
            'type' => 'required|string|max:50',
            'price' => 'required|numeric',
            'fuelType' => 'required|string|max:50',
            'image' => 'nullable|image|max:2048',
        ]);

        // Create new Car instance
        $car = new Car();
        $car->name = $request->name;
        $car->model = $request->model;
        $car->color = $request->color;
        $car->type = $request->type;
        $car->price = $request->price;
        $car->fuelType = $request->fuelType;

        // Handle image upload
        if ($request->hasFile('image')) {
            // Store in "public/cars" folder
            $path = $request->file('image')->store('cars', 'public');
            $car->image = $path;
        }

        $car->save();

        return response()->json([
            'message' => 'Car added successfully',
            'car' => $car,
        ], 201);
    }
}
